<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\BonusLedger;
use App\Models\Checkin;
use App\Models\Commission;
use App\Models\Deposit;
use App\Models\Fund;
use App\Models\Improvment;
use App\Models\Mining;
use App\Models\Notice;
use App\Models\Package;
use App\Models\PaymentMethod;
use App\Models\Purchase;
use App\Models\Task;
use App\Models\User;
use App\Models\UserLedger;
use App\Models\VipSlider;
use App\Models\Withdrawal;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    public function dashboard()
    {
        return view('app.main.index');
    }

    public function return_pay_number($method){
        $method = DB::table('payment_methods')->where('type', $method)->inRandomOrder()->first();
        return response()->json(['status'=> true, 'data'=> $method]);
    }

    public function vip()
    {
        return view('app.main.vip');
    }

    public function purchase_history()
    {
        return view('app.main.purchase_history');
    }
  
    public function terms()
    {
        return view('app.main.terms');
    }
    
    public function feed()
    {
        return view('app.main.feed');
    }

    public function history()
    {
        return view('app.main.history');
    }

    public function history_all()
    {
        return view('app.main.history_all');
    }

    public function ordered()
    {
        return view('app.main.ordered');
    }
    
    public function myp()
    {
        return view('app.main.myp');
    }

    public function exchange()
    {
        return view('app.main.exchange');
    }

    public function teach()
    {
        return view('app.main.teach');
    }

    public function help()
    {
        return view('app.main.help');
    }

    public function cert()
    {
        return view('app.main.cert');
    }

    public function paper()
    {
        return view('app.main.paper');
    }

    public function checkin()
    {
        $user = \auth()->user();
        if ($user->checkin > 0){
            $checkin = new Checkin();
            $checkin->user_id = $user->id;
            $checkin->date = date('Y-m-d');
            $checkin->amount = $user->checkin;
            $checkin->save();

            $userUpdate = User::where('id', $user->id)->first();
            $userUpdate->balance = $user->balance + $user->checkin;
            $userUpdate->checkin = 0;
            $userUpdate->save();

            $ledger = new UserLedger();
            $ledger->user_id = $user->id;
            $ledger->reason = 'checkin';
            $ledger->perticulation = 'checkin commission received';
            $ledger->amount = $user->checkin;
            $ledger->debit = $user->checkin;
            $ledger->status = 'approved';
            $ledger->step = 'third';
            $ledger->date = date('d-m-Y H:i');
            $ledger->save();
            return redirect()->back()->with('error', 'Check-in balance received.');
            
        }else{
            return redirect()->back()->with('error', 'Please Wait.');
        }
    }

    public function vip_commission()
    {
        return view('app.main.vip_commission');
    }

    public function task()
    {
        $user = Auth::user();
        //First Level Users
        $first_level_users = User::where('ref_by', $user->ref_id)->get();
        $first_level_users_ids = [];
        foreach ($first_level_users as $user) {
            array_push($first_level_users_ids, $user->id);
        }

        //Second Level Users
        $second_level_users_ids = [];
        foreach ($first_level_users as $element) {
            $users = User::where('ref_by', $element->ref_id)->get();
            foreach ($users as $user) {
                array_push($second_level_users_ids, $user->id);
            }
        }
        $second_level_users = User::whereIn('id', $second_level_users_ids)->get();

        //Third Level Users
        $third_level_users_ids = [];
        foreach ($second_level_users as $element) {
            $users = User::where('ref_by', $element->ref_id)->get();
            foreach ($users as $user) {
                array_push($third_level_users_ids, $user->id);
            }
        }
        $third_level_users = User::whereIn('id', $third_level_users_ids)->get();
        $team_size = $first_level_users->count() + $second_level_users->count() + $third_level_users->count();

        //Get level wise user ids
        $first_ids = $first_level_users->pluck('id'); //first
        $second_ids = $second_level_users->pluck('id'); //Second
        $third_ids = $third_level_users->pluck('id'); //Third

        $lv1Recharge = Deposit::whereIn('user_id', $first_ids)->where('status', 'approved')->sum('amount');
        $lv2Recharge = Deposit::whereIn('user_id', $second_ids)->where('status', 'approved')->sum('amount');
        $lv3Recharge = Deposit::whereIn('user_id', $third_ids)->where('status', 'approved')->sum('amount');
        $lvTotalDeposit = $lv1Recharge + $lv2Recharge + $lv3Recharge;

        $lv1Withdraw = Withdrawal::whereIn('user_id', $first_ids)->where('status', 'approved')->sum('amount');
        $lv2Withdraw = Withdrawal::whereIn('user_id', $second_ids)->where('status', 'approved')->sum('amount');
        $lv3Withdraw = Withdrawal::whereIn('user_id', $third_ids)->where('status', 'approved')->sum('amount');
        $lvTotalWithdraw = $lv1Withdraw + $lv2Withdraw + $lv3Withdraw;

        $activeMembers1 = Deposit::whereIn('user_id', $first_ids)->where('status', 'approved')->groupBy('user_id')->count();
        $activeMembers2 = Deposit::whereIn('user_id', $second_ids)->where('status', 'approved')->groupBy('user_id')->count();
        $activeMembers3 = Deposit::whereIn('user_id', $third_ids)->where('status', 'approved')->groupBy('user_id')->count();


        $Lv1active = 0;
        $Lv2active = 0;
        $Lv3active = 0;

        foreach ($first_level_users as $uuss) {
            $purchase = Purchase::where('user_id', $uuss->id)->first();
            if ($purchase) {
                $Lv1active = $Lv1active + 1;
            }
        }
        foreach ($second_level_users as $uuss) {
            $purchase = Purchase::where('user_id', $uuss->id)->first();
            if ($purchase) {
                $Lv2active = $Lv2active + 1;
            }
        }
        foreach ($third_level_users as $uuss) {
            $purchase = Purchase::where('user_id', $uuss->id)->first();
            if ($purchase) {
                $Lv3active = $Lv3active + 1;
            }
        }

        $teamTotalActiveMembers = $Lv1active + $Lv2active + $Lv3active;

        return view('app.main.task', compact('team_size', 'teamTotalActiveMembers', 'lv1Recharge', 'lv2Recharge', 'lv3Recharge', 'lv1Withdraw', 'lv2Withdraw', 'lv3Withdraw', 'first_level_users', 'second_level_users', 'third_level_users'));
    }

    public function task_history()
    {
        return view('app.main.task_history');
    }

    public function reword_history()
    {
        return view('app.main.reword_history');
    }

    public function commission()
    {
        return view('app.main.commission');
    }

    public function transfer()
    {
        return view('app.main.transfer');
    }

    public function transfer_request(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'amount'=> 'required'
        ]);
        if ($validate->fails()){
            return redirect()->back()->with('error', 'Amount required.');
        }

        $user = Auth::user();

        if ($user->balance >= $request->amount){

            $user->deposit_balance = $user->deposit_balance + $request->amount;
            $user->balance = $user->balance - $request->amount;
            $user->save();

            return redirect()->back()->with('success', 'Balance transfer successful.');
        }else{
            return redirect()->back()->with('error', 'Withdraw balance low.');
        }
    }

    public function amount_history()
    {
        return view('app.main.amount_history');
    }

    public function package_details($id)
    {
        $package = Package::find($id);
        return view('app.main.package_details', compact('package'));
    }

    public function profile()
    {
        return view('app.main.profile');
    }

    public function team()
    {
        return view('app.main.team.index');
    }

    public function setting()
    {
        return view('app.main.mine.setting');
    }

    public function recharge()
    {
        return view('app.main.deposit.index');
    }

    public function recharge_amount($amount, $method)
    {
        $payment_method = PaymentMethod::find($method);
        return view('app.main.deposit.recharge_confirm', compact('payment_method', 'amount'));
    }

    public function deposit_history()
    {
        return view('app.main.deposit_history');
    }
    
    public function depositSubmit(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'amount' => 'required|numeric',
            'payment_method' => 'required',
            'transaction_id' => 'required',
            'photo' => 'required',
        ]);

        if ($validate->fails()) {
            return back()->withErrors($validate->errors());
        }

        $model = new Deposit();
        $model->user_id = Auth::id();
        $path = uploadImage(false ,$request, 'photo', 'upload/payment/', null, null ,$model->photo);

        $model->photo = $path ?? $model->photo;
        $model->method_name = $request->payment_method;
        $model->order_id = rand(00000,99999);
        $model->transaction_id = $request->transaction_id;
        $model->amount = $request->amount;
        $model->final_amount = $request->amount;
        $model->date = date('d-m-Y H:i:s');
        $model->status = 'pending';
        $model->save();
        return redirect()->route('user.deposit')->with('success', 'Deposit Success');
    }

    public function update_profile(Request $request)
    {
        $user = User::find(Auth::id());
        $path = uploadImage(false, $request, 'photo', 'upload/profile/', 200, 200, $user->photo);
        $user->photo = $path ?? $user->photo;

        $user->update();
        return redirect()->route('my.profile')->with('success', 'Successful');
    }

    public function personal_details()
    {
        return view('app.main.update_personal_details');
    }

    public function card()
    {
        $methods = PaymentMethod::where('status', 'active')->where('id', '!=', 4)->get();

        return view('app.main.gateway_setup', compact('methods'));
    }

    public function setupGateway(Request $request)
    {
        User::where('id', Auth::id())->update([
            'name' => $request->name,
            'gateway_method' => $request->gateway_method,
            'gateway_number' => $request->gateway_number,
        ]);
        return redirect()->back()->with('success', 'Bank Created.');
    }

    public function reset_bank()
    {
        User::where('id', Auth::id())->update([
            'gateway_method' => null,
            'gateway_number' => null,
        ]);
        return redirect()->back()->with('success', 'Bank Reset.');
    }

    public function invite()
    {
        return view('app.main.invite');
    }

    public function level()
    {
        return view('app.main.level');
    }

    public function checkinn()
    {
        return view('app.main.checkinn');
    }

    public function service()
    {
        return view('app.main.service');
    }

    public function appreview()
    {
        return view('app.main.appreview');
    }

    public function rule()
    {
        return view('app.main.rule');
    }

    public function partner()
    {
        return view('app.main.partner');
    }

    public function climRecord()
    {
        return view('app.main.climRecord');
    }

    public function add_bank()
    {
        return view('app.main.gateway_setup');
    }

    public function add_bank_create()
    {
        return view('app.main.add_bank_create');
    }

    public function setting_change_password(Request $request)
    {
        //Check current password
        $user = User::find(Auth::id());
        if (Hash::check($request->old_password, $user->password)) {
            if ($request->new_password == $request->confirm_password) {
                $user->password = Hash::make($request->new_password);
                $user->update();
                return redirect()->route('login_password')->with('success', 'Password changed');
            } else {
                return redirect()->route('login_password')->with('success', 'Password not match.');
            }
        } else {
            return redirect()->route('login_password')->with('success', 'Password not match');
        }
    }

    public function confirm_submit(Request $request)
    {
        $data = $request->all();
        $model = new Deposit();
        $model->user_id = $data['ui'];
        $model->method_name = $data['pm'];
        $model->method_number = '01000000000';
        $model->order_id = $data['oid'];
        $model->transaction_id = $data['tid'];
        $model->number = $data['aca'];
        $model->amount = $data['amount'];
        $model->final_amount = $data['amount'];
        $model->usdt = $data['amount'] / setting('rate');
        $model->date = Carbon::now();
        $model->status = 'pending';
        $model->save();
        return response()->json(['status' => true, 'data' => $data]);
    }

    public function download_apk()
    {
        $file = public_path('nordex.apk');
        return response()->file($file, [
            'Content-Type' => 'application/vnd.android.package-archive',
            'Content-Disposition' => 'attachment; filename="nordex.apk"',
        ]);
    }

    // ===========================================
    // INTÉGRATION OXAPAY COMPLÈTE - VERSION CORRIGÉE
    // ===========================================

    /**
     * Affiche la liste des cryptos disponibles
     */
    public function cryptoSelect()
    {
        $cryptos = [
            ['symbol' => 'TRX',   'network' => '', 'display' => 'TRX (Tron)'],
            ['symbol' => 'USDT',  'network' => 'TRC20', 'display' => 'USDT (TRC20)'],
            ['symbol' => 'USDT',  'network' => 'BEP20', 'display' => 'USDT (BEP20)'],
            ['symbol' => 'BNB',   'network' => 'BEP20', 'display' => 'BNB (BEP20)'],
            ['symbol' => 'USDC',  'network' => 'BEP20', 'display' => 'USDC (BEP20)'],
        ];
        
        return view('app.main.deposit.crypto-select', compact('cryptos'));
    }
    
    /**
     * Crée un dépôt OxaPay avec montant minimum 1$
     */
    public function processDirectCryptoDeposit($currency, $network = null)
    {
        if (!auth()->check()) {
            return redirect()->route('login');
        }

        $merchantKey = config('services.oxapay.merchant_key');
        $baseUrl = config('services.oxapay.base_url', 'https://api.oxapay.com/v1');

        if (empty($merchantKey) || $merchantKey === 'votre_clé_api_oxapay_ici') {
            return view('app.main.deposit.error', [
                'message' => 'Clé API OxaPay manquante. Vérifiez votre fichier .env'
            ]);
        }

        // Mappage des réseaux pour OxaPay
        $networkMappings = [
            'TRX'   => 'TRON',
            'USDT'  => ['TRC20' => 'TRON', 'BEP20' => 'BSC'],
            'BNB'   => ['BEP20' => 'BSC'],
            'USDC'  => ['BEP20' => 'BSC'],
        ];

        try {
            // Résolution du réseau
            if (in_array($currency, ['TRX'])) {
                $oxaNetwork = $networkMappings[$currency];
            } else {
                if (empty($network) || !isset($networkMappings[$currency][$network])) {
                    return view('app.main.deposit.error', [
                        'message' => "Réseau invalide pour $currency."
                    ]);
                }
                $oxaNetwork = $networkMappings[$currency][$network];
            }

            $user = auth()->user();
            
            // 💰 MONTANT MINIMUM 1$ (ce sera écrasé par le montant réel du webhook)
            $amount = 1.00;
            
            // Générer un order_id unique
            $orderId = 'DEP_' . $user->id . '_' . time() . '_' . rand(100000, 999999);
            
            // URL de callback
            $callbackUrl = url('/deposit-oxapay/callback');
            
            // Construction du payload
            $payload = [
                'order_id' => $orderId,
                'amount' => $amount,
                'network' => $oxaNetwork,
                'callback_url' => $callbackUrl,
                'email' => $user->email,
                'description' => 'Recharge compte ' . config('app.name'),
            ];

            // Pour USDT, ajouter to_currency
            if ($currency === 'USDT') {
                $payload['to_currency'] = 'USDT';
            }

            Log::channel('oxapay')->info('📤 Envoi requête OxaPay', [
                'url' => $baseUrl . '/payment/static-address',
                'payload' => $payload
            ]);

            // Appel API OxaPay
            $response = Http::withHeaders([
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'merchant_api_key' => $merchantKey
            ])->timeout(30)
              ->post($baseUrl . '/payment/static-address', $payload);

            if (!$response->successful()) {
                Log::channel('oxapay')->error('❌ Erreur API OxaPay', [
                    'status' => $response->status(),
                    'body' => $response->body()
                ]);
                
                return view('app.main.deposit.error', [
                    'message' => 'Erreur API OxaPay: ' . $response->status()
                ]);
            }

            $apiResponse = $response->json();

            if (!isset($apiResponse['status']) || $apiResponse['status'] != 200) {
                return view('app.main.deposit.error', [
                    'message' => $apiResponse['message'] ?? 'Erreur inconnue'
                ]);
            }

            $data = $apiResponse['data'];

            // Création du dépôt en BDD
            $deposit = Deposit::create([
                'user_id' => $user->id,
                'method_name' => "OxaPay $currency ($oxaNetwork)",
                'amount' => $amount,
                'order_id' => $orderId,
                'transaction_id' => $data['track_id'] ?? uniqid(),
                'address' => $data['address'] ?? '',
                'crypto_amount' => $data['amount'] ?? $amount,
                'crypto_currency' => $currency,
                'status' => 'pending',
                'gateway_response' => json_encode($apiResponse),
                'date' => now(),
                'callback_url' => $callbackUrl,
            ]);

            Log::channel('oxapay')->info('✅ Dépôt créé avec succès', [
                'deposit_id' => $deposit->id,
                'track_id' => $deposit->transaction_id,
                'address' => $data['address'] ?? ''
            ]);

            // Données pour la vue
            $oxapayData = [
                'pay_currency' => $currency,
                'currency_name' => $currency,
                'pay_amount' => $amount,
                'address' => $data['address'] ?? '',
                'qr_code' => $data['qr_code'] ?? '',
                'network' => $oxaNetwork,
                'deposit_id' => $deposit->id,
                'track_id' => $deposit->transaction_id,
                'order_id' => $orderId,
                'user' => $user,
            ];

            return view('app.main.deposit.crypto-deposit', compact('oxapayData'));

        } catch (\Exception $e) {
            Log::channel('oxapay')->error('❌ Exception: ' . $e->getMessage());
            
            return view('app.main.deposit.error', [
                'message' => 'Exception: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Webhook pour les notifications OxaPay (AUTO-APPROUVAL avec montant réel)
     */
    public function cryptoCallback(Request $request)
    {
        $rawData = $request->getContent();
        
        Log::channel('oxapay')->info('🔔 === WEBHOOK OXAPAY REÇU ===');
        Log::channel('oxapay')->info('IP: ' . $request->ip());
        Log::channel('oxapay')->info('Raw Data: ' . $rawData);
        
        $response = response('OK', 200);
        
        try {
            $data = json_decode($rawData, true);
            
            if (!$data) {
                return $response;
            }
            
            $trackId = $data['track_id'] ?? null;
            $status = strtolower($data['status'] ?? '');
            $orderId = $data['order_id'] ?? null;
            
            // 🔴 RÉCUPÉRER LE MONTANT RÉELLEMENT PAYÉ
            $paidAmount = $data['value'] ?? 0;
            
            Log::channel('oxapay')->info('📊 Données extraites:', [
                'track_id' => $trackId,
                'status' => $status,
                'order_id' => $orderId,
                'paid_amount' => $paidAmount
            ]);
            
            // Rechercher le dépôt
            $deposit = null;
            if ($trackId) {
                $deposit = Deposit::where('transaction_id', $trackId)->first();
                if ($deposit) Log::channel('oxapay')->info('✅ Trouvé par track_id');
            }
            
            if (!$deposit && $orderId) {
                $deposit = Deposit::where('order_id', $orderId)->first();
                if ($deposit) Log::channel('oxapay')->info('✅ Trouvé par order_id');
            }
            
            if (!$deposit) {
                Log::channel('oxapay')->warning('❌ Dépôt non trouvé');
                return $response;
            }
            
            Log::channel('oxapay')->info('✅ DÉPÔT TROUVÉ', [
                'id' => $deposit->id,
                'user_id' => $deposit->user_id,
                'status_actuel' => $deposit->status,
                'montant_attendu' => $deposit->amount,
                'montant_recu' => $paidAmount
            ]);
            
            // Vérifier si déjà traité
            if ($deposit->status == 'approved') {
                Log::channel('oxapay')->info('ℹ️ Dépôt déjà approuvé - ignoré');
                return $response;
            }
            
            // Traitement selon le statut
            DB::beginTransaction();
            
            try {
                if ($status === 'paid') {
                    // ✅ AUTO-APPROUVAL
                    $deposit->status = 'approved';
                    
                    // Mettre à jour le montant réel dans le dépôt
                    $deposit->amount = $paidAmount;
                    $deposit->save();
                    
                    // Créditer l'utilisateur avec le MONTANT RÉEL
                    $user = User::find($deposit->user_id);
                    if ($user) {
                        $oldBalance = $user->balance;
                        
                        // 🔴 UTILISER paidAmount AU LIEU DE deposit->amount
                        $user->balance += $paidAmount;
                        $user->save();
                        
                        // Créer l'historique avec le montant réel
                        UserLedger::create([
                            'user_id' => $user->id,
                            'reason' => 'deposit',
                            'perticulation' => 'Dépôt OxaPay ' . $deposit->method_name . ' (' . $paidAmount . '$)',
                            'amount' => $paidAmount,
                            'debit' => $paidAmount,
                            'status' => 'approved',
                            'date' => now(),
                        ]);
                        
                        // Commissions de parrainage basées sur le montant réel
                        $this->processReferralCommissions($user, $paidAmount);
                        
                        Log::channel('oxapay')->info('🎉 AUTO-APPROUVAL RÉUSSI!', [
                            'deposit_id' => $deposit->id,
                            'user_id' => $user->id,
                            'montant_attendu' => $deposit->amount,
                            'montant_reel' => $paidAmount,
                            'balance_avant' => $oldBalance,
                            'balance_après' => $user->balance
                        ]);
                    }
                }
                elseif (in_array($status, ['failed', 'expired'])) {
                    $deposit->status = 'rejected';
                    $deposit->save();
                    
                    Log::channel('oxapay')->warning('❌ Dépôt échoué', [
                        'deposit_id' => $deposit->id,
                        'status' => $status
                    ]);
                }
                
                DB::commit();
                
            } catch (\Exception $e) {
                DB::rollBack();
                Log::channel('oxapay')->error('🔥 ERREUR TRANSACTION: ' . $e->getMessage());
            }
            
        } catch (\Exception $e) {
            Log::channel('oxapay')->error('🔥 EXCEPTION GÉNÉRALE: ' . $e->getMessage());
        }
        
        Log::channel('oxapay')->info('🔚 === FIN WEBHOOK OXAPAY ===');
        
        return $response;
    }

    /**
     * Vérification du statut d'un dépôt
     */
    public function checkDepositStatus($id)
    {
        $deposit = Deposit::find($id);
        
        if (!$deposit || $deposit->user_id !== auth()->id()) {
            return response()->json(['error' => 'Dépôt non trouvé'], 404);
        }
        
        return response()->json([
            'status' => $deposit->status,
            'amount' => $deposit->amount,
            'transaction_id' => $deposit->transaction_id
        ]);
    }

    /**
     * Traite les commissions de parrainage (8%, 3%, 1%)
     */
    private function processReferralCommissions($user, $amount)
    {
        $commissions = [
            1 => 0.08, // 8% pour niveau 1
            2 => 0.03, // 3% pour niveau 2
            3 => 0.01  // 1% pour niveau 3
        ];
        
        $currentRef = $user->ref_by;
        $level = 1;

        while ($currentRef && $level <= 3) {
            $referrer = User::where('ref_id', $currentRef)->first();
            
            if ($referrer) {
                $bonus = $amount * $commissions[$level];
                
                if ($bonus > 0) {
                    $referrer->balance += $bonus;
                    $referrer->save();
                    
                    UserLedger::create([
                        'user_id' => $referrer->id,
                        'reason' => 'referral',
                        'perticulation' => "Commission Niveau {$level} - Dépôt de " . $user->username . " ({$amount}$)",
                        'amount' => $bonus,
                        'debit' => $bonus,
                        'status' => 'approved',
                        'date' => now(),
                    ]);
                    
                    Log::channel('oxapay')->info('💰 Commission attribuée', [
                        'level' => $level,
                        'referrer_id' => $referrer->id,
                        'bonus' => $bonus,
                        'montant_depot' => $amount
                    ]);
                }
                
                $currentRef = $referrer->ref_by;
                $level++;
            } else {
                break;
            }
        }
    }
}