<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class CryptoIconController extends Controller
{
    public function show($icon)
    {
        // Liste des icônes disponibles
        $availableIcons = [
            'bnb.png', 'doge.png', 'eth.png', 'logo.png', 'ltc.png',
            'matic.png', 'sol.png', 'trx.png', 'usdc.png', 'usdt.png',
            'usdt20.png', 'xrp.png'
        ];
        
        // Nettoyer le nom du fichier
        $icon = basename($icon);
        
        // Vérifier si l'icône est dans la liste
        if (!in_array($icon, $availableIcons)) {
            $icon = 'logo.png';
        }
        
        $path = public_path('crypto/' . $icon);
        
        if (!file_exists($path)) {
            // Essayer logo.png comme fallback
            $path = public_path('crypto/logo.png');
            
            if (!file_exists($path)) {
                // Créer une réponse vide avec headers appropriés
                $response = response('', 404);
                $response->header('Content-Type', 'image/png');
                $response->header('Cache-Control', 'public, max-age=300');
                return $response;
            }
        }
        
        // Retourner le fichier avec les headers
        return response()->file($path, [
            'Content-Type' => 'image/png',
            'Cache-Control' => 'public, max-age=31536000'
        ]);
    }
}